#ifndef __APPLICATION_H
#define __APPLICATION_H


#include "atomic.h"     // class Atomic

class Application : public Atomic
{
public:
	Application( const string &name = "Application" );					//Default constructor

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &applicationIN;
	const Port &applicationFillingComplete;
	Port &applicationOUT;
	Time applicationTime;
	int applicationNum;
	int totalApplicationNum;
	bool done;
	bool sendApplication;

};

// ** inline ** //

inline string Application::className() const
{
	return "Application" ;
}

#endif   //__APPLICATION_H
